﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace RTFLibDemo
{
    using GDF;
    using Properties;
    using RTF;

    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            RTFBuilderbase rb = new RTFBuilder();
            BuilderCode(rb);
            this.richTextBox1.Rtf = rb.ToString();
        }

        private void BuilderCode(RTFBuilderbase rb)
        {
            //rb.Font(RTFFont.Consolas);
            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("OBT Upload:");
            rb.AppendLine("Uploads available Banx items to Concur");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("Auto Name Change:");
            rb.AppendLine("AMERICAN AIR - $100 (minimum Name Change Value)");
            rb.AppendLine("ALASKA AIRLI - $125 (minimum Name Change Value)");
            rb.AppendLine("JET BLUE - $150 (minimum Name Change Value)");
            rb.AppendLine("DELTA AIR LI - $100 (minimum Name Change Value)");
            rb.AppendLine("FRONTIER AIR - $125 (minimum Name Change Value)");
            rb.AppendLine("UNITED AIRLI - $100 (minimum Name Change Value)");
            rb.AppendLine("WEST JET - $75 (minimum Name Change Value)");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("Set Match on Import:");
            rb.AppendLine("N/A");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).AppendLine("Custom Fields Used:");
            rb.AppendLine("N/A");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("Notifications:");
            rb.AppendLine("90 Day Notification");
            rb.AppendLine("180 Day Notification");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("Banx Select Rules:");
            rb.AppendLine("GLOBAL RULE - Tickets on file for traveler in PNR (Rollup matches PNR; Traveler Profile matches PNR; Passenger Last Name matches PNR)");
            rb.AppendLine("GLOBAL RULE - Tickets on file for traveler's company marked for name change  (Rollup matches PNR; name change true)");
            rb.AppendLine("GLOBAL RULE - Tickets on file for traveler's company with no profile and last name matches, no personal/spouse tickets");
            rb.AppendLine("GLOBAL RULE - Tickets on file for traveler's company that are not selected for name change and expire within 60 days and airline allows name changes, no partials, no internationals, no awards, no prior agency ticket, no tickets excluded from name change or no personal/spouse tickets");
            rb.AppendLine("GLOBAL RULE - Personal/Spouse tickets on file for traveler's company and the last name matches");
            rb.AppendLine("GLOBAL RULE - Awards on file for traveler's company");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("Airline Contracts and Service Funds:");
            rb.AppendLine("DELTA AIR LI - Service Funds");
            rb.AppendLine();

            rb.FontStyle(FontStyle.Bold).ForeColor(KnownColor.Blue).AppendLine("Auto Reports:");
            rb.AppendLine("30 Day Greg Nielson Team - Sent To (gnielson@tandt.com; semgrs@tandt.com) Monthly");
            rb.AppendLine("30 Day Seattle Expire - Sent To (semgrs@tandt.com; sesupervisors@tandt.com) Monthly");
            rb.AppendLine("Available AA DL UA WN - Open for Name Change - Sent To (sesupervisors@tandt.com; semgrs@tandt.com) Daily");
            rb.AppendLine("SE Decline Report - Sent To (sesupervisors@tandt.com; semgrs@tandt.com) Daily");
            rb.AppendLine("NWEA Availiable Items - Sent To (LYNN.TOWNE@NWEA.ORG) Monthly");
            rb.AppendLine("NWEA Quarterly Avalable - Sent To (LYNN.TOWNE@NWEA.ORG) Quarterly");
            rb.AppendLine("NWEA Expired Items - Sent To (LYNN.TOWNE@NWEA.ORG) Monthly");
            rb.AppendLine("NWEA Used Items - Sent To (LYNN.TOWNE@NWEA.ORG) Monthly");
            rb.AppendLine("NWEA Will Expire 30 Days - Sent To (LYNN.TOWNE@NWEA.ORG) Monthly");
            rb.AppendLine("NWEA Will Expire 60 days - Sent To (LYNN.TOWNE@NWEA.ORG) Monthly");
            rb.AppendLine("Available SE Tickets on File - Sent To (semgrs@tandt.com) Weekly");
            rb.AppendLine();

            //rb.Append("append text1").Append("append text2").Append("append text3").Append("append text4").AppendLine();
            //rb.FontStyle(FontStyle.Bold).AppendLine("Bold");
            //rb.FontStyle(FontStyle.Italic).AppendLine("Italic");
            //rb.FontStyle(FontStyle.Strikeout).AppendLine("Strikeout");
            //rb.FontStyle(FontStyle.Underline).AppendLine("Underline");
            //rb.FontStyle(FontStyle.Bold | FontStyle.Italic | FontStyle.Strikeout | FontStyle.Underline).AppendLine("Underline/Bold/Italic/Underline");
            //rb.ForeColor(KnownColor.Red).AppendLine("ForeColor Red");
            //rb.BackColor(KnownColor.Yellow).AppendLine("BackColor Yellow");
            //
            //rb.ForeColor(KnownColor.Red).BackColor(KnownColor.Yellow).AppendLine("ForeColor Red , BackColor Yellow");
            //
            //rb.AppendLine("1. append 2 lines - First Line \r\n2. Second Line (correctly appending rtf codes for secondline)");
            //rb.Font(RTFFont.Georgia).AppendLine("Change to Georgia Font!");
            //rb.Font(RTFFont.Consolas).AppendLine("Change to Consolas Font!");
            //rb.Font(RTFFont.Garamond).AppendLine("Change to Garamond Font!");
            //rb.Font(RTFFont.MSSansSerif).AppendLine("Change to MSSansSerif Font!)");
            //rb.Font(RTFFont.Arial).AppendLine("Change to Arial Font!(default)");
            //rb.Font(RTFFont.ArialBlack).AppendLine("Change to ArialBlack Font!");
            //
            //rb.FontSize(30).Font(RTFFont.ArialBlack).AppendLine("Change to ArialBlack Font Size 30");
            //
            ////Commit Format changes
            //rb.FontSize(20).Font(RTFFont.ArialBlack);
            //
            //using (rb.FormatLock())
            //{
            //    rb.AppendLine("FormatLock to ArialBlack Font Size 20");
            //    rb.AppendLine("FormatLock to ArialBlack Font Size 20");
            //
            //}
            //rb.AppendLine("Inserting Image");
            //rb.InsertImage(Resources.Complications);
            //rb.AppendLine("Inserted Image");
            //
            //   rb.AppendLine("Creating Table");
            //   rb.AppendPage();
            //            rb.AppendPara();
            //            rb.Reset();
            //
            //   AddRow1(rb, "Row 1 Cell 1", "Row 1 Cell 2", "Row 1 Cell 3");
            //   AddRow1(rb, "Row 2 Cell 1", "Row 2 Cell 2", "Row 2 Cell 3");
            //   AddRow1(rb, "Row 3 Cell 1", "Row 3 Cell 2", "Row 3 Cell 3");
            //   AddRow1(rb, "Row 4 Cell 1", "Row 4 Cell 2", "Row 4 Cell 3");
            //   AddRow1(rb, "Row 5 Cell 1", "Row 5 Cell 2", "Row 5 Cell 3");
            //
            //   rb.AppendLine("Inserting cell images");
            //   rb.AppendPara();
            //     rb.Reset();
            //     rb.AppendPara();
            //     rb.Reset();
            //   AddRow2(rb, "Row 5 Cell 1", "Row 5 Cell 2", "Row 5 Cell 3");
            //   rb.AppendPara();
            //   rb.AppendLine("Inserting MultiLine Cells --> Fails to display correctly in RichTextBox");
            //   rb.Reset();
            //   rb.AppendPara();
            //   AddRow1(rb, "Row 5\r\n Cell 1", "Row 5 \r\n Cell 2", "Row 5 \r\n Cell 3");
            //   rb.Reset();
            //   rb.AppendPara();
        }
        private void button2_Click(object sender, EventArgs e)
        {
            Size s = gdfDisplayBox1.ClientSize;
            s.Height -= 31;


            GDFPageManager manager = new GDFPageManager(s, SystemColors.Window);

            GDFBuilder sb = new GDFBuilder(manager);
            BuilderCode(sb);
            gdfDisplayBox1.SetPages(manager.Pages);


        }

        /// <summary>
        /// Adds the row1.
        /// </summary>
        /// <param name="rb">The rb.</param>
        /// <param name="cellContents">The cell contents.</param>
        private void AddRow1(RTFBuilderbase rb, params string[] cellContents)
        {
            Padding p = new Padding { All = 50 };
            RTFRowDefinition rd = new RTFRowDefinition(88, RTFAlignment.TopLeft, RTFBorderSide.Default, 15, SystemColors.WindowText, p);
            RTFCellDefinition[] cds = new RTFCellDefinition[cellContents.Length];
            for (int i = 0; i < cellContents.Length; i++)
            {
                cds[i] = new RTFCellDefinition(88 / cellContents.Length, RTFAlignment.TopLeft, RTFBorderSide.Default, 15, Color.Blue, Padding.Empty);
            }
            int pos = 0;
            foreach (RTFBuilderbase item in rb.EnumerateCells(rd, cds))
            {
                item.ForeColor(KnownColor.Blue).FontStyle(FontStyle.Bold | FontStyle.Underline);
                item.BackColor(Color.Yellow);
                item.Append(cellContents[pos++]);
            }
        }
        /// <summary>
        /// utility function to facilitate insertion of cellContents within a row
        /// </summary>
        /// <param name="rb">The rb.</param>
        /// <param name="cellContents">The cell contents.</param>
        private void AddRow2(RTFBuilderbase rb, params string[] cellContents)
        {
            Padding p = new Padding { All = 50 };//ignored
            // create RTFRowDefinition
            RTFRowDefinition rd = new RTFRowDefinition(88, RTFAlignment.TopLeft, RTFBorderSide.Default, 15, SystemColors.WindowText, p);
            // Create RTFCellDefinitions
            RTFCellDefinition[] cds = new RTFCellDefinition[cellContents.Length];
            for (int i = 0; i < cellContents.Length; i++)
            {
                cds[i] = new RTFCellDefinition(88 / cellContents.Length, RTFAlignment.TopLeft, RTFBorderSide.Default, 15, Color.Blue, Padding.Empty);
            }
            int pos = 0;
            // enumerate over cells
            // each cell
            foreach (RTFBuilderbase item in rb.EnumerateCells(rd, cds))
            {
                item.InsertImage(Resources.Complications);
                item.ForeColor(KnownColor.Blue).FontStyle(FontStyle.Bold | FontStyle.Underline);
                item.BackColor(Color.Yellow);
                item.Append(cellContents[pos++]);
            }
        }

        /// <summary>
        /// Merges the output of one RtfBuilder into another
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void button3_Click(object sender, EventArgs e)
        {
            RTFBuilderbase rb = new RTFBuilder();

            BuilderCode(rb);
            RTFBuilderbase rb2 = new RTFBuilder();
            BuilderCode(rb2);
            rb.AppendRTFDocument(rb2.ToString());
            this.richTextBox2.Rtf = rb.ToString();
        }

        /// <summary>
        /// Merges the contents of 2 RichTextBoxes
        /// </summary>
        /// <param name="sender">The source of the event.</param>
        /// <param name="e">The <see cref="System.EventArgs"/> instance containing the event data.</param>
        private void button4_Click(object sender, EventArgs e)
        {
            RTFBuilderbase rb = new RTFBuilder();
            BuilderCode(rb);
            this.richTextBox3.Rtf = rb.ToString();
            this.richTextBox4.Rtf = rb.ToString();
            rb.Clear();
            rb.AppendRTFDocument(this.richTextBox3.Rtf);
            rb.AppendRTFDocument(this.richTextBox4.Rtf);
            this.richTextBox2.Rtf = rb.ToString();
        }
    }
}
